class CTFBase2 extends Actor;

var byte Team;	// Player Team, 255 = None for player.
var CTF1Flag OtherFlag;
var MSGamesMutator MSMod;
var FlagSpawn FlagSpawn;
var CTFBase1 BlueBase;
var CTF2FlagBlue OtherFlag2;

function Tick(float Deltatime)
{
 
 ForEach AllActors(class'CTF1Flag',OtherFlag)
 { 
  if (OtherFlag != None)
  {
   CheckBases(OtherFlag);
  }
 }
 ForEach AllActors(class'CTF2FlagBlue',OtherFlag2)
 { 
  if (OtherFlag2 != None)
  {
   CheckBases2(OtherFlag2);
  }
 }
}

function CheckBases(CTF1Flag OtherFlag)
{
    ForEach VisibleActors(class'CTF1Flag',OtherFlag,DrawScale*10,Location)
    {
     ForEach AllActors(class'FlagSpawn',FlagSpawn)
     { 
     ForEach AllActors(class'MSGamesMutator',MSMod)
     {
      if ((MSMod.bInCTF1) && (FlagSpawn != None) && (OtherFlag != None))
      {
       if (OtherFlag.Base != None)
       {
        return;
       }
       else
       {
        MSMod.RedScore += 1;
        BroadcastMessage("|p2Team Red has scored! They now have "$MSMod.RedScore$" points!", true, 'CriticalEvent');
        OtherFlag.SetLocation(FlagSpawn.Location);
        if (MSMod.RedScore >= MSMod.ScoreToWin)
        {
         MSMod.CTFVictory();
        }
       }
      }
     }
    } 
   }
}

function CheckBases2(CTF2FlagBlue OtherFlag2)
{
    ForEach VisibleActors(class'CTF2FlagBlue',OtherFlag2,DrawScale*10,Location)
    {
     ForEach AllActors(class'MSGamesMutator',MSMod)
     {
     ForEach AllActors(class'CTFBase1',BlueBase)
     {
      if ((MSMod.bInCTF2) && (BlueBase != None) && (OtherFlag2 != None))
      {
       if (OtherFlag2.Base != None)
       {
        return;
       }
       else
       {
        MSMod.RedScore += 1;
        BroadcastMessage("|p2Team Red has scored! They now have "$MSMod.RedScore$" points!", true, 'CriticalEvent');
        OtherFlag2.SetLocation(BlueBase.Location);
        if (MSMod.RedScore >= MSMod.ScoreToWin)
        {
         MSMod.CTFVictory();
        }
       }
      }
     }
     }
    } 
}

defaultproperties
{
     Team=0
     Style=STY_Translucent
     Mesh=LodMesh'DeusExItems.SphereEffect'
     bUnlit=True
     bCollideActors=False
     bCollideWorld=False
     bProjTarget=False
     DrawType=DT_Mesh
     Physics=PHYS_None
     Texture=FireTexture'Effects.Liquid.Virus_SFX'
     Skin=FireTexture'Effects.Liquid.Virus_SFX'
     DrawScale=10.000000
     MultiSkins(0)=FireTexture'Effects.Liquid.Virus_SFX'
}
